#include "stdafx.h"

#include "InformacjeODysku.h"

BOOL PobierzInformacjeODysku(char literaDysku, DaneODysku &diskInfo)
{
   diskInfo.literaDysku = toupper(literaDysku);

   //Ustalanie wstepnych wartosci
   diskInfo.czyDyskDostepny = TRUE;

   diskInfo.typDysku = 0;
   wcscpy_s(diskInfo.typDyskuOpis,L"");
   diskInfo.calkowitaPrzestrzen = 0;
   diskInfo.wolnaPrzestrzen = 0;
   diskInfo.zajetaPrzestrzen = 0;
   diskInfo.wolnaPrzestrzenUlamek = 0;
   diskInfo.wolnaPrzestrzenProcenty = 0;
   wcscpy_s(diskInfo.nazwaDysku,L"");
   diskInfo.numerSeryjnyDysku = 0;
   wcscpy_s(diskInfo.nazwaFAT,L"");
   diskInfo.maksymalnaDlugoscPlikuLubKatalogu = 0;
   diskInfo.maksymalnaDlugoscSciezki = 0;

   //Sciezka katalogu glownego na dysku
   TCHAR katalogGlownyDysku[4];
   katalogGlownyDysku[0]=diskInfo.literaDysku;
   katalogGlownyDysku[1]='\0';
   wcscat_s(katalogGlownyDysku,L":\\");

   //Typ napedu (drive type)
   diskInfo.typDysku = GetDriveType(katalogGlownyDysku);
   switch(diskInfo.typDysku)
   {
      case 0:
         wcscpy_s(diskInfo.typDyskuOpis,L"Napd nie istnieje");
         diskInfo.czyDyskDostepny = FALSE;
         break;
      case 1:
         wcscpy_s(diskInfo.typDyskuOpis,L"Dysk nie jest sformatowany");
         diskInfo.czyDyskDostepny = FALSE;
         break;
      case DRIVE_REMOVABLE: wcscpy_s(diskInfo.typDyskuOpis,L"Dysk wymienny"); break;
      case DRIVE_FIXED: wcscpy_s(diskInfo.typDyskuOpis,L"Dysk lokalny"); break;
      case DRIVE_REMOTE: wcscpy_s(diskInfo.typDyskuOpis,L"Dysk sieciowy"); break;
      case DRIVE_CDROM: wcscpy_s(diskInfo.typDyskuOpis,L"Pyta CDROM"); break;
      case DRIVE_RAMDISK: wcscpy_s(diskInfo.typDyskuOpis,L"RAM Drive"); break;
      default: wcscpy_s(diskInfo.typDyskuOpis,L"Typ dysku nierozpoznany"); break;
   }

   //Jezeli dysk niedostepny, to konczymy
   if (!diskInfo.czyDyskDostepny) return FALSE;

   //Ilosc wolnego miejsca na dysku (disk free space)
   //Typy argumentow niezgodne z Win32 SDK
   BOOL Wynik = ::GetDiskFreeSpaceEx(
       katalogGlownyDysku,
       NULL,
       (ULARGE_INTEGER*)&(diskInfo.calkowitaPrzestrzen),
       (ULARGE_INTEGER*)&(diskInfo.wolnaPrzestrzen));

   diskInfo.zajetaPrzestrzen = diskInfo.calkowitaPrzestrzen - diskInfo.wolnaPrzestrzen;

   if (Wynik && (diskInfo.calkowitaPrzestrzen != 0))
   {
      diskInfo.wolnaPrzestrzenUlamek = diskInfo.wolnaPrzestrzen/ 
      (double)diskInfo.calkowitaPrzestrzen;
      diskInfo.wolnaPrzestrzenProcenty = (unsigned char)ROUND(100 * diskInfo.wolnaPrzestrzenUlamek);
   }
   else
   {
      diskInfo.wolnaPrzestrzenUlamek = 0;
      diskInfo.wolnaPrzestrzenProcenty = 0;
      diskInfo.czyDyskDostepny = FALSE;
      return FALSE;
   }

   //Nazwa dysku, typ FAT, numer seryjny (GetVolumeInformation)
   unsigned long wlasnosciSystemuPlikow;

   Wynik = GetVolumeInformation(katalogGlownyDysku,
                 diskInfo.nazwaDysku,
                 DI_MAX_LENGTH,
                 &(diskInfo.numerSeryjnyDysku),
                 &(diskInfo.maksymalnaDlugoscPlikuLubKatalogu),
                 &(wlasnosciSystemuPlikow),
                 diskInfo.nazwaFAT,
                 DI_MAX_LENGTH);

   diskInfo.maksymalnaDlugoscSciezki = MAX_PATH;

   return Wynik;
}
